////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link CDDCDataFeederProtocol} allows to set CDDC data values.
 */
NS_REFINED_FOR_SWIFT
@protocol CDDCDataFeederProtocol <NSObject>

/**
 * Sets the value for the release date of the application (publication date).
 * @param applicationReleaseDate Release date of the application (publication date) in milliseconds since epoch.
 * @param error a NSError raised if there is an error during the process.
 * @return true if the call is successful, If an error occurred the reason will be put in the error.
*/
- (BOOL)setApplicationReleaseDate:(long)applicationReleaseDate error:(NSError **)error;

/**
 * Sets the value for device rooted.
 * @param deviceRooted Indicates if the device is rooted or jailbroken.
 */
- (void)setDeviceRooted:(BOOL)deviceRooted
DEPRECATED_MSG_ATTRIBUTE("This method has been renamed to -[CDDCDataFeederProtocol setDeviceJailbroken:]");

/**
 * Sets the value for device jailbroken.
 * @param deviceJailbroken Indicates if the device is jailbroken.
 */
- (void)setDeviceJailbroken:(BOOL)deviceJailbroken;

/**
 * Sets the value for the RASP protection status
 * @param raspProtected Indicates if the application is rasp protected.
 */
- (void)setRaspProtected:(BOOL)raspProtected;

/**
 * Sets the value for the untrusted keyboard status.
 * @param untrustedKeyboard Indicates if the application has an untrusted keyboard.
 */
- (void)setUntrustedKeyboard:(BOOL)untrustedKeyboard
DEPRECATED_MSG_ATTRIBUTE("This method will be removed in a future version");

/**
 * Sets the value for the untrusted screen reader status.
 * @param screenReader Indicates if the application is has an untrusted screen reader.
 */
- (void)setUntrustedScreenReaders:(BOOL)screenReader
DEPRECATED_MSG_ATTRIBUTE("This method will be removed in a future version");

/**
 * Sets the value for the hooking frameworks status.
 * @param hookingFrameworks Indicates if the application has hooking frameworks.
 */
- (void)setHookingFrameworks:(BOOL)hookingFrameworks;

/**
 * Sets the value for the native code hooks status.
 * @param nativeCodeHooks Indicates if the application has native code hooks.
 */
- (void)setNativeCodeHooks:(BOOL)nativeCodeHooks 
DEPRECATED_MSG_ATTRIBUTE("This method will be removed in a future version");

/**
 * Sets the value for the attached debugger status.
 * @param debuggerAttached Indicates if the application has an attached debugger.
 */
- (void)setDebuggerAttached:(BOOL)debuggerAttached;

/**
 * Sets the value for the repackaging status.
 * @param applicationRepackaged Indicates if the application has been repackaged.
 */
- (void)setApplicationRepackaged:(BOOL)applicationRepackaged;

/**
 * Sets the value for the screenshot detected status.
 * @param screenshotDetected Indicates if a screenshot of the application has been taken.
 */
- (void)setScreenshotDetected:(BOOL)screenshotDetected;

/**
 * Sets the value for library injection detected status.
 * @param libraryInjectionDetected Indicates if an untrusted library has tried to be injected into the application during runtime.
 */
- (void)setLibraryInjectionDetected:(BOOL)libraryInjectionDetected;

/**
 * Sets the value in percent for the probability of the device to be rooted, using heuristics. A value of 0 indicates that the device is most likely not rooted while a value of 100 indicates that the device is most likely rooted.
 * @param rootingProbability Probability of the device to be rooted. Integer between 0 and 100.
 * @param error a NSError raised if there is an error during the process.
 * @return true if the call is successful, If an error occurred the reason will be put in the error.
*/
- (BOOL)setRootingProbability:(int)rootingProbability error:(NSError **)error 
DEPRECATED_MSG_ATTRIBUTE("This method will be removed in a future version");

@end

NS_ASSUME_NONNULL_END
